 aR  d 
 w  m
^<      h	 oU    nSystem-wide$NOLIST
	NAME	Patch
      
CGROUP	GROUP	CODE

	PUBLIC	InitOSPatch, ResetOSPatch
	PUBLIC	CALLRealOsCallDriver, CallRealGetEntrypoint
	PUBLIC	CALLRealGetDeviceList, CALLRealOsRemoveDevice

	PUBLIC    OsMassFileSystem, MsDosFileSystem

	EXTRN 	MyGetEntryPoint: FAR, MyOsCallDriver: FAR
	EXTRN     MyGetDeviceList: FAR, MyCpPartitionInfo: FAR
	EXTRN	MyUpdateDeviceList: FAR, MyOsRemoveDevice: FAR

	EXTRN     OsMassFileSystemShell: FAR, pMsDosEntrypoint: DWORD

osIntNum	EQU	112
cpIntNum	EQU	113
getEntry	EQU	3Ch
OsCall	EQU	5Ah
getDev    EQU       55
cpPart    EQU       73
updateDev EQU	6ah
osRemove	EQU	35h


CODE	SEGMENT	PARA PUBLIC 'CODE'
	ASSUME	CS:CGROUP


OSOldOff		DW ?
OSOldSeg		DW ?

CpOldOff		DW ?
CpOldSeg		DW ?

getEntryOff	DW OFFSET CGROUP:MyGetEntryPoint
getEntrySeg	DW CGROUP

OsCallOff		DW OFFSET CGROUP:MyOSCallDriver
OsCallSeg		DW CGROUP

CpGetDevOff	DW OFFSET CGROUP:MyGetDeviceList
CpGetDevSeg	DW CGROUP

CpPartOff		DW OFFSET CGROUP:MyCpPartitionInfo
CpPartSeg		DW CGROUP

OsUpdateOff	DW OFFSET CGROUP:MyUpdateDeviceList
OsUpdateSeg	DW CGROUP

OsRemoveOff	DW OFFSET CGROUP:MyOsRemoveDevice
OsRemoveSeg	DW CGROUP

$EJ



; This is a generic routine to go to the old Os routine.  It is expected that 
; the parameters are correct on the stack and that the last parameter is the
; routine number to call.  This routine will take off the routine number and
; will call the old routine, not touching the parms at all.

CALLRealGetEntryPoint	LABEL 	FAR
CALLRealOsCallDriver	LABEL	FAR
CALLRealOsRemoveDevice 	LABEL	FAR
CallRealRoutine	PROC	FAR
	POP	BX
	POP	ES

	POP	AX	; rtn num in AX for indirect call

	PUSH	ES
	PUSH	BX

	MOV	ES, CS:osOldSeg
	MOV	BX, CS:osOldOff

	INC	BX
	INC	BX	; call indirect

	PUSH	ES
	PUSH	BX   	; Jump to Routine
	RET
CallRealRoutine	ENDP

; This is a generic routine to go to the old Cp routine.  It is expected that 
; the parameters are correct on the stack and that the last parameter is the
; routine number to call.  This routine will take off the routine number and
; will call the old routine, not touching the parms at all.

CALLRealGetDeviceList	LABEL 	FAR
CallRealCpRoutine	PROC	FAR
	POP	BX
	POP	ES

	POP	AX	; rtn num in AX for indirect call

	PUSH	ES
	PUSH	BX

	MOV	ES, CS:cpOldSeg
	MOV	BX, CS:cpOldOff

	INC	BX
	INC	BX	; call indirect

	PUSH	ES
	PUSH	BX   	; Jump to Routine
	RET
CallRealCpRoutine	ENDP

$EJ

InitOsPatch PROC NEAR

	XOR	AX, AX
	MOV	ES, AX

	CLI

	MOV	AX, osIntNum  
	SHL	AX, 1
	SHL	AX, 1
	MOV	BX, AX

	MOV	AX, ES:[BX+2]
	MOV	CS:osOldSeg, AX

	MOV	AX, ES:[BX+0]
	MOV	CS:osOldOff, AX

	MOV	AX, SEG osIntEntry
	MOV	ES:[BX+2], AX

	MOV	AX, OFFSET osIntEntry
	MOV	ES:[BX+0], AX

	MOV	AX, CpIntNum  
	SHL	AX, 1
	SHL	AX, 1
	MOV	BX, AX

	MOV	AX, ES:[BX+2]
	MOV	CS:cpOldSeg, AX

	MOV	AX, ES:[BX+0]
	MOV	CS:cpOldOff, AX

	MOV	AX, SEG cpIntEntry
	MOV	ES:[BX+2], AX

	MOV	AX, OFFSET cpIntEntry
	MOV	ES:[BX+0], AX

	STI

	RET

InitOsPatch ENDP

ResetOsPatch PROC NEAR

	XOR	AX, AX
	MOV	ES, AX

	CLI

	MOV	AX, osIntNum	
	SHL	AX, 1
	SHL	AX, 1
	MOV	BX, AX

	MOV	AX, CS:osOldSeg
	MOV	ES:[BX+2], AX

	MOV	AX, CS:osOldOff
	MOV	ES:[BX+0], AX

	MOV	AX, cpIntNum	
	SHL	AX, 1
	SHL	AX, 1
	MOV	BX, AX

	MOV	AX, CS:cpOldSeg
	MOV	ES:[BX+2], AX

	MOV	AX, CS:cpOldOff
	MOV	ES:[BX+0], AX

	STI
	RET

ResetOsPatch ENDP

$EJ

; These routines are used to patch out the OS calls 

OsIntEntry LABEL FAR
	JMP	SHORT OSInterrupt

OSIndEntry:
	JMP	SHORT OSIndirect

OSInterrupt:
	POP	BX		; get IP
	POP	ES		; get CS
	POPF			; set flags

	MOV	AX, ES:[BX] 	; get call #
	XOR	AH, AH
	INC	BX		; skip call #

	PUSH	ES		; push CS
	PUSH	BX		; push IP
 
OSIndirect:			; AX holds routine number
	CMP	AL, getEntry
	JE	callGetEntry
	CMP	AL, osCall
	JE	callOsCall
	CMP	AL, updateDev
	JE	callOsUpdate
	CMP	AL, osRemove
	JE	callOsRemove

	MOV	ES, CS:OsOldSeg 	; No patch
	MOV	BX, CS:OsOldOff

	INC	BX		; get addr of
	INC	BX		; indirect

	PUSH	ES		; push CS
	PUSH	BX		; push IP

OSLongRet PROC FAR

noOSCall:	RET

OSLongRet	ENDP

CallGetEntry:
	JMP	DWORD PTR CS:getEntryOff
CallOsCall:
	JMP	DWORD PTR CS:osCallOff
CallOsUpdate:
	JMP	DWORD PTR CS:osUpdateOff
CallOsRemove:
	JMP	DWORD PTR CS:osRemoveOff

$EJECT

; These routines are used to patch out the CP calls 

CpIntEntry LABEL FAR
	JMP	SHORT CpInterrupt

CpIndEntry:
	JMP	SHORT CpIndirect

CpInterrupt:
	POP	BX		; get IP
	POP	ES		; get CS
	POPF			; set flags

	MOV	AX, ES:[BX] 	; get call #
	XOR	AH, AH
	INC	BX		; skip call #

	PUSH	ES		; push CS
	PUSH	BX		; push IP
 
CpIndirect:			; AX holds routine number
	CMP	AL, getDev
	JE	callGetDev
	CMP	AL, cpPart
	JE	callCpPart 

	MOV	ES, CS:cpOldSeg 	; No patch
	MOV	BX, CS:cpOldOff

	INC	BX		; get addr of
	INC	BX		; indirect

	PUSH	ES		; push CS
	PUSH	BX		; push IP

CpLongRet PROC FAR

	RET

CpLongRet	ENDP

CallGetDev:
	JMP	DWORD PTR CS:CpGetDevOff
CallCpPart:
	JMP	DWORD PTR CS:CpPartOff

;  OsMassFileSystem: PROCEDURE (request, pPl, pError);

; This routine will 1) pass the callers DS register and 2) call the
; OsMassFileSystemShell routine.  This is required because the MS-DOS
; file system is in the integrid ROMS and they expect the DS to be already
; setup.

request EQU WORD PTR SS:[BP+16]
pPl     EQU DWORD PTR SS:[BP+12]
pError  EQU DWORD PTR SS:[BP+8]

OsMassFileSystem PROC FAR
  PUSH DS
  PUSH BP
  MOV  BP, SP

  MOV  AX, request
  PUSH AX

  LES  DI, pPl
  PUSH ES
  PUSH DI

  LES  DI, pError
  PUSH ES
  PUSH DI

  PUSH DS	          ; callers DS

  CALL OsMassFileSystemShell

  POP  BP
  POP  DS
  RET  10
OsMassFileSystem ENDP
PURGE request
PURGE pPl
PURGE pError

$EJECT

;  MsDosFileSystem: PROCEDURE (request, pPl,pError, callersDS) CLEAN;
;    DCL request      WORD;
;    DCL callersDS    WORD;
;    DCL pPl          PTR;
;    DCL pError       PTR;

; This routine will 1) setup the callers DS and 2) call the MS-DOS file 
; system 


request   EQU WORD PTR SS:[BP+16]
pPl       EQU DWORD PTR SS:[BP+12]
pError    EQU DWORD PTR SS:[BP+8]
callersDS EQU WORD PTR SS:[BP+6]

MsDosFileSystem PROC NEAR
  PUSH DS
  PUSH BP
  MOV  BP, SP

  MOV  AX, request
  PUSH AX

  LES  DI, pPl
  PUSH ES
  PUSH DI

  LES  DI, pError
  PUSH ES
  PUSH DI

  PUSH DS
  POP  ES			; ES = DS

  MOV  AX, callersDS
  MOV  DS, AX

  CALL DWORD PTR ES:pMsDosEntrypoint	; call the MS-DOS file system

  POP  BP
  POP  DS
  RET  12
MsDosFileSystem ENDP


CODE	ENDS

	END
